// AvsdApiTestDlg.h : header file
//

#if !defined(AFX_AvsdApiTestDLG_H__D1AE4DF3_858C_4D11_AE05_41A2802686B1__INCLUDED_)
#define AFX_AvsdApiTestDLG_H__D1AE4DF3_858C_4D11_AE05_41A2802686B1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "afxwin.h"
#include "avsdapi.h"


/////////////////////////////////////////////////////////////////////////////
// CAvsdApiTestDlg dialog

class CAvsdApiTestDlg : public CDialog
{
// Construction
public:
	CAvsdApiTestDlg(CWnd* pParent = NULL);	// standard constructor
	~CAvsdApiTestDlg();

// Dialog Data
	//{{AFX_DATA(CAvsdApiTestDlg)
	enum { IDD = IDD_AvsdApiTest_DIALOG };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAvsdApiTestDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CAvsdApiTestDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnEventsApply();
	afx_msg void OnBnClickedBtnPlug();
	afx_msg void OnClose();
	afx_msg void OnBnClickedBtnUnplug();
	afx_msg void OnBnClickedBtnIsPlugged();
	afx_msg void OnBnClickedBtnIsOpened();
	afx_msg void OnBnClickedBtnSignalsGet();
	afx_msg void OnBnClickedBtnSignalsSet();
	afx_msg void OnBnClickedBtnSettingsGet();
	afx_msg void OnBnClickedBtnInstall();
	afx_msg void OnBnClickedBtnUninstall();
	afx_msg void OnBnClickedBtnPortbufLen();
	afx_msg void OnBnClickedBtnConnect();
	afx_msg void OnBnClickedBtnDisconnect();
	afx_msg void OnBnClickedBtnGetconnect();
	afx_msg void OnBnClickedBtnReadByte();
	afx_msg void OnBnClickedBtnWriteByte();
	afx_msg void OnBnClickedBtnReadStr();
	afx_msg void OnBnClickedBtnWriteStr();
	afx_msg void OnBnClickedBtnEventslogClear();
	afx_msg void OnBnClickedBtnAbout();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	void ShowError(const char *Descr, DWORD dwError);
	int GetPlugPort();
	int GetPort1();
	int GetPort2();
	int GetEventsPort();
	long GetReadCount();

	BOOL PortSettingsToStr(PAVSD_PORT_SETTINGS pPortSettings, CString* ps);

	static UINT DataEventThread(LPVOID Context);
	static UINT SettingsEventThread(LPVOID Context);
	static UINT FlowEventThread(LPVOID Context);
	static UINT StateEventThread(LPVOID Context);

	HANDLE m_hDataEvent;
	HANDLE m_hSettingsEvent;
	HANDLE m_hFlowEvent;
	HANDLE m_hStateEvent;

	BOOL bStopDataEventThread;
	BOOL bStopSettingsEventThread;
	BOOL bStopFlowEventThread;
	BOOL bStopStateEventThread;

	CWinThread *m_pDataThread;
	CWinThread *m_pFlowThread;
	CWinThread *m_pSettingsThread;
	CWinThread *m_pStateThread;

	DWORD m_EventPort;

	CString m_sEventLog;

public:
	CString m_sPlugPort;
	enum
	{
		NUM_CH_CS = 6,
		NUM_CS_EVENTS = 4
	};
	CButton m_arrChCS[NUM_CH_CS];
	CButton m_arrChEvents[NUM_CS_EVENTS];
	CString m_sSettings;
	CString m_sPath;
	CString m_sPort1;
	CString m_sPort2;
	CString m_sByte;
	CString m_sString;
	CString m_sEventsPort;
	CEdit m_edtEventsLog;
	CString m_sReadCount;

	void OnDataEvent();
	void OnSettingsEvent();
	void OnFlowEvent();
	void OnStateEvent();
	//control to logging
	CComboBox comboLog;
	void Logging(LPCTSTR lpszString);
	void LoggingLastError(LPCTSTR lpszString, DWORD dwError);
	
	HANDLE handles[256];

	afx_msg void OnOpenPort();
	afx_msg void OnCloseCOM();
	afx_msg void OnWriteCOM();
	CString m_sStringCOM;
	afx_msg void OnReadCOM();
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_AvsdApiTestDLG_H__D1AE4DF3_858C_4D11_AE05_41A2802686B1__INCLUDED_)
